<?php

use yii\helpers\Url;
use yii\helpers\Html;
use app\models\Product;

/** @var yii\web\View $this */
/** @var Product[] $featuredProducts */
/** @var Product[] $newProducts */

$this->title = 'Хлебный Дворик - свежая выпечка каждый день';
?>
<div class="site-index">
    <div class="zagolovok">
        <h2>Хлебный Дворик - свежая выпечка каждый день!</h2>
        <p>У нас самая свежая выпечка!</p>
    </div>
    <div class="quick-links mb-5">
        <div class="row g-4">
            <div class="col-md-2 col-6">
                <a href="<?= Url::to(['product/index']) ?>" class="quick-link-card text-center text-decoration-none">
                    <div class="icon-wrapper mb-3">
                        <span class="display-3">🥖</span>
                    </div>
                    <h5 class="text-dark">Каталог</h5>
                    <p class="text-muted small">Все товары</p>
                </a>
            </div>
            <div class="col-md-2 col-6">
                <?php if (Yii::$app->user->isGuest): ?>
                    <a href="<?= Url::to(['site/signup']) ?>" class="quick-link-card text-center text-decoration-none">
                        <div class="icon-wrapper mb-3">
                            <span class="display-3">📝</span>
                        </div>
                        <h5 class="text-dark">Регистрация</h5>
                        <p class="text-muted small">Создать аккаунт</p>
                    </a>
                <?php else: ?>
                    <a href="<?= Url::to(['cart/index']) ?>" class="quick-link-card text-center text-decoration-none">
                        <div class="icon-wrapper mb-3">
                            <span class="display-3">🛒</span>
                        </div>
                        <h5 class="text-dark">Корзина</h5>
                        <p class="text-muted small">Ваши товары</p>
                    </a>
                <?php endif; ?>
            </div>
            <div class="col-md-2 col-6">
                <?php if (Yii::$app->user->isGuest): ?>
                    <a href="<?= Url::to(['site/login']) ?>" class="quick-link-card text-center text-decoration-none">
                        <div class="icon-wrapper mb-3">
                            <span class="display-3">🔐</span>
                        </div>
                        <h5 class="text-dark">Войти</h5>
                        <p class="text-muted small">В личный кабинет</p>
                    </a>
                <?php else: ?>
                    <a href="<?= Url::to(['order/index']) ?>" class="quick-link-card text-center text-decoration-none">
                        <div class="icon-wrapper mb-3">
                            <span class="display-3">📦</span>
                        </div>
                        <h5 class="text-dark">Заказы</h5>
                        <p class="text-muted small">История покупок</p>
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- 3. Блок популярных товаров -->
    <div class="featured-products mb-5">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="section-title">
                <span class="me-2">⭐</span>Популярные товары
            </h2>
            <a href="<?= Url::to(['product/index']) ?>" class="btn btn-outline-warning">
                Все товары
            </a>
        </div>
        <div class="row g-4">
            <?php if (!empty($featuredProducts)): ?>
                <?php foreach ($featuredProducts as $product): ?>
                    <div class="col-lg-3 col-md-6">
                        <div class="product-card card h-100 border-warning border-2 shadow-sm hover-shadow">
                            <div class="position-relative">
                                <?= Html::a(
                                    Html::img('@web/images/' . $product->image, [
                                        'class' => 'card-img-top',
                                        'alt' => $product->name,
                                        'style' => 'height: 200px; object-fit: cover; width: 100%;'
                                    ]),
                                    ['product/view', 'id' => $product->id],
                                    ['class' => 'text-decoration-none']
                                ) ?>
                                <span class="badge bg-danger position-absolute top-0 end-0 m-2 fs-6">Хит</span>
                            </div>
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title">
                                    <?= Html::a(Html::encode($product->name),
                                        ['product/view', 'id' => $product->id],
                                        ['class' => 'text-decoration-none text-dark fw-bold']
                                    ) ?>
                                </h5>
                                <p class="card-text text-muted small flex-grow-1">
                                    <?= \yii\helpers\StringHelper::truncate($product->description, 80, '...') ?>
                                </p>
                                <div class="mt-auto">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="text-primary fw-bold fs-4">
                                            <?= $product->price ?> ₽
                                        </span>
                                        <?php if ($product->counts > 0): ?>
                                            <?php if (Yii::$app->user->isGuest || Yii::$app->user->identity->is_admin != 1): ?>
                                                <?= Html::a('В корзину', ['cart/add', 'id' => $product->id], [
                                                    'class' => 'btn btn-warning btn-sm'
                                                ]) ?>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Нет в наличии</span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="mt-2">
                                        <span class="badge bg-light text-dark">
                                            <i class="bi bi-box"></i> <?= $product->counts ?> шт.
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12">
                    <div class="alert alert-info">
                        Популярные товары временно отсутствуют
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- 4. Блок новинок -->
    <div class="new-products mb-5">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="section-title">
                <span class="me-2">🆕</span>Новинки
            </h2>
            <a href="<?= Url::to(['product/index', 'sort' => 'new']) ?>" class="btn btn-outline-success">
                Все новинки
            </a>
        </div>
        <div class="row g-4">
            <?php if (!empty($newProducts)): ?>
                <?php foreach ($newProducts as $product): ?>
                    <div class="col-lg-3 col-md-6">
                        <div class="product-card card h-100 border-success border-2 shadow-sm hover-shadow">
                            <div class="position-relative">
                                <?= Html::a(
                                    Html::img('@web/images/' . $product->image, [
                                        'class' => 'card-img-top',
                                        'alt' => $product->name,
                                        'style' => 'height: 200px; object-fit: cover; width: 100%;'
                                    ]),
                                    ['product/view', 'id' => $product->id],
                                    ['class' => 'text-decoration-none']
                                ) ?>
                                <span class="badge bg-success position-absolute top-0 end-0 m-2 fs-6">Новинка</span>
                            </div>
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title">
                                    <?= Html::a(Html::encode($product->name),
                                        ['product/view', 'id' => $product->id],
                                        ['class' => 'text-decoration-none text-dark fw-bold']
                                    ) ?>
                                </h5>
                                <p class="card-text text-muted small flex-grow-1">
                                    <?= \yii\helpers\StringHelper::truncate($product->description, 80, '...') ?>
                                </p>
                                <div class="mt-auto">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <span class="text-success fw-bold fs-4">
                                            <?= $product->price ?> ₽
                                        </span>
                                        <?php if ($product->counts > 0): ?>
                                            <?php if (Yii::$app->user->isGuest || Yii::$app->user->identity->is_admin != 1): ?>
                                                <?= Html::a('В корзину', ['cart/add', 'id' => $product->id], [
                                                    'class' => 'btn btn-warning btn-sm'
                                                ]) ?>
                                            <?php endif; ?>
                                        <?php else: ?>
                                            <span class="badge bg-secondary">Нет в наличии</span>
                                        <?php endif; ?>
                                    </div>
                                    <div class="mt-2">
                                        <span class="badge bg-light text-dark">
                                            <i class="bi bi-box"></i> <?= $product->counts ?> шт.
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="col-12">
                    <div class="alert alert-info">
                        Новинки временно отсутствуют
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>


    <div class="contact-info mt-5 pt-5 border-top">
        <div class="row">
            <div class="col-md-4 mb-4">
                <h4 class="mb-3">
                    <span class="me-2">🏪</span>Хлебный Дворик
                </h4>
                <p class="text-muted">
                    Свежая выпечка каждый день с 1998 года. Традиционные рецепты, натуральные ингредиенты.
                </p>
                <div class="mt-3">
                    <p><strong>📍 Адрес:</strong> ул. Пирогова, 15, Москва</p>
                    <p><strong>📞 Телефон:</strong> +7 (495) 123-45-67</p>
                    <p><strong>✉ Email:</strong> info@hlebny-dvorik.ru</p>
                </div>
            </div>
            <div class="col-md-4 mb-4">
                <h4 class="mb-3">
                    <span class="me-2">⏰</span>Часы работы
                </h4>
                <ul class="list-unstyled">
                    <li class="mb-2">
                        <span class="badge bg-light text-dark me-2">Пн-Пт</span>
                        8:00 - 21:00
                    </li>
                    <li class="mb-2">
                        <span class="badge bg-light text-dark me-2">Сб</span>
                        9:00 - 20:00
                    </li>
                    <li class="mb-2">
                        <span class="badge bg-light text-dark me-2">Вс</span>
                        9:00 - 19:00
                    </li>
                </ul>
            </div>
            <div class="col-md-4 mb-4">
                <h4 class="mb-3">
                    <span class="me-2">🗺️</span>Как добраться
                </h4>
                <div class="map-placeholder bg-light rounded-3 p-4 text-center" style="height: 200px;">
                    <div class="d-flex flex-column justify-content-center h-100">
                        <span class="display-4 mb-3">📍</span>
                        <p class="text-muted mb-0">Метро "Бабушкинская"</p>
                        <p class="text-muted">5 минут пешком от выхода из метро</p>
                        <a href="#" class="btn btn-outline-primary btn-sm">Построить маршрут</a>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<style>
    /* Стили для главной страницы */
    .site-index {
        background-color: #fffef9;
    }

    .hero-section {
        border-radius: 20px;
        overflow: hidden;
        box-shadow: 0 10px 30px rgba(139, 69, 19, 0.15);
    }

    .carousel-image {
        background-size: cover;
        background-position: center;
    }

    .quick-link-card {
        padding: 20px 10px;
        border-radius: 15px;
        background: #fffaf0;
        border: 2px solid #f5e6d3;
        transition: all 0.3s ease;
        display: block;
        height: 100%;
    }

    .quick-link-card:hover {
        transform: translateY(-5px);
        background: #fff8e1;
        border-color: #d4a574;
        box-shadow: 0 10px 20px rgba(212, 165, 116, 0.2);
    }

    .icon-wrapper {
        transition: transform 0.3s ease;
    }

    .quick-link-card:hover .icon-wrapper {
        transform: scale(1.1);
    }

    .section-title {
        color: #8B4513;
        font-family: 'Georgia', serif;
        font-weight: bold;
        position: relative;
        padding-bottom: 10px;
    }

    .section-title::after {
        content: "";
        position: absolute;
        bottom: 0;
        left: 0;
        width: 60px;
        height: 3px;
        background: linear-gradient(90deg, #D4A574, #8B4513);
        border-radius: 3px;
    }

    .product-card {
        transition: all 0.3s ease;
        border-radius: 15px;
        overflow: hidden;
    }

    .product-card:hover {
        transform: translateY(-5px);
    }

    .product-card.hover-shadow:hover {
        box-shadow: 0 15px 30px rgba(139, 69, 19, 0.15) !important;
    }

    .card-img-top {
        transition: transform 0.5s ease;
    }

    .product-card:hover .card-img-top {
        transform: scale(1.05);
    }

    .badge {
        font-size: 0.85em;
        padding: 5px 10px;
    }

    .map-placeholder {
        border: 2px dashed #d4a574;
    }

    @media (max-width: 768px) {
        .carousel-inner {
            height: 300px !important;
        }

        .display-4 {
            font-size: 2rem;
        }

        .lead {
            font-size: 1.2rem !important;
        }
    }
</style>

<script>
    // Автопрокрутка карусели
    document.addEventListener('DOMContentLoaded', function () {
        const myCarousel = document.getElementById('mainCarousel');
        if (myCarousel) {
            const carousel = new bootstrap.Carousel(myCarousel, {
                interval: 5000,
                wrap: true
            });
        }

        // Анимация появления карточек товаров
        const productCards = document.querySelectorAll('.product-card');
        productCards.forEach((card, index) => {
            card.style.opacity = '0';
            card.style.transform = 'translateY(20px)';

            setTimeout(() => {
                card.style.transition = 'all 0.5s ease';
                card.style.opacity = '1';
                card.style.transform = 'translateY(0)';
            }, index * 100);
        });
    });
</script>