<?php
use yii\helpers\Url;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\data\ActiveDataProvider;
use yii\widgets\ListView;

/** @var yii\web\View $this */
/** @var ActiveDataProvider $dataProvider */
/** @var app\models\Category[] $categories */
/** @var string $sort */
$this->title = 'Каталог товаров';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="product-index">
    <h1><?= Html::encode($this->title) ?></h1>

    <div class="row">
        <div class="col-md-3">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Фильтры</h5>
                </div>
                <div class="card-body">
                    <?php $form = ActiveForm::begin([
                        'method' => 'get',
                        'action' => ['product/index'],
                        'options' => ['class' => 'filter-form']
                    ]); ?>

                    <h6 class="fw-bold mt-3">Категории</h6>
                    <div class="category-filters">
                        <?= Html::checkbox('category[]', false, [
                            'value' => '',
                            'id' => 'category-all',
                            'class' => 'form-check-input category-filter'
                        ]) ?>
                        <?= Html::label('Все категории', 'category-all', ['class' => 'form-check-label']) ?>

                        <?php foreach ($categories as $category): ?>
                            <div class="form-check">
                                <?= Html::checkbox('category[]', in_array($category->id, $selectedCategories ?? []), [
                                    'value' => $category->id,
                                    'id' => 'category-' . $category->id,
                                    'class' => 'form-check-input category-filter'
                                ]) ?>
                                <?= Html::label($category->name, 'category-' . $category->id, ['class' => 'form-check-label']) ?>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <hr class="my-3">

                    <h6 class="fw-bold">Цена</h6>
                    <div class="row">
                        <div class="col-md-6">
                            <?= Html::input('number', 'price_min', $priceMin ?? null, [
                                'class' => 'form-control',
                                'placeholder' => 'Мин',
                                'min' => 0
                            ]) ?>
                        </div>
                        <div class="col-md-6">
                            <?= Html::input('number', 'price_max', $priceMax ?? null, [
                                'class' => 'form-control',
                                'placeholder' => 'Макс',
                                'min' => 0
                            ]) ?>
                        </div>
                    </div>

                    <div class="mt-3">
                        <?= Html::submitButton('Применить', ['class' => 'btn btn-primary w-100']) ?>
                        <?= Html::a('Сбросить', ['product/index'], ['class' => 'btn btn-outline-secondary w-100 mt-2']) ?>
                    </div>

                    <?php ActiveForm::end(); ?>
                </div>
            </div>
        </div>

        <!-- Товары -->
        <div class="col-md-9">
            <!-- Сортировка -->
            <div class="card mb-3">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <span class="text-muted">
                                Найдено товаров: <?= $dataProvider->getTotalCount() ?>
                            </span>
                        </div>
                        <div class="d-flex align-items-center">
                            <span class="me-2">Сортировка:</span>
                            <div class="dropdown">
                                <?= Html::a($sortLabels[$sort] ?? 'По умолчанию', '#', [
                                    'class' => 'btn btn-outline-secondary dropdown-toggle',
                                    'data-bs-toggle' => 'dropdown',
                                    'aria-expanded' => false
                                ]) ?>
                                <ul class="dropdown-menu">
                                    <?php foreach ($sortLabels as $key => $label): ?>
                                        <li>
                                            <?= Html::a($label, [
                                                'product/index',
                                                'sort' => $key,
                                                'category' => Yii::$app->request->get('category'),
                                                'price_min' => Yii::$app->request->get('price_min'),
                                                'price_max' => Yii::$app->request->get('price_max')
                                            ], ['class' => 'dropdown-item']) ?>
                                        </li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <?= ListView::widget([
                    'dataProvider' => $dataProvider,
                    'itemView' => '_product',
                    'layout' => "{items}\n{pager}",
                    'options' => ['class' => 'row'],
                    'itemOptions' => ['class' => 'col-md-4 mb-4'],
                    'pager' => [
                        'options' => ['class' => 'pagination justify-content-center'],
                        'linkOptions' => ['class' => 'page-link'],
                        'disabledListItemSubTagOptions' => ['tag' => 'a', 'class' => 'page-link'],
                    ],
                ]) ?>
            </div>
        </div>
    </div>
</div>