<?php
use yii\helpers\Url;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\data\ActiveDataProvider;
use yii\widgets\ListView;

/** @var yii\web\View $this */
/** @var ActiveDataProvider $dataProvider */
$this->title = 'История заказов';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="order-history">
    <h1><?= Html::encode($this->title) ?></h1>

    <?php if ($dataProvider->getTotalCount() > 0): ?>
        <div class="orders-list">
            <?= ListView::widget([
                'dataProvider' => $dataProvider,
                'itemView' => '_order_item',
                'layout' => "{items}\n{pager}",
                'emptyText' => 'У вас пока нет заказов.',
                'pager' => [
                    'options' => ['class' => 'pagination justify-content-center'],
                    'linkOptions' => ['class' => 'page-link'],
                    'disabledListItemSubTagOptions' => ['tag' => 'a', 'class' => 'page-link'],
                ],
            ]) ?>
        </div>
    <?php else: ?>
        <div class="alert alert-info">
            <p>У вас пока нет заказов.</p>
            <p><?= Html::a('Перейти в каталог', ['product/index'], ['class' => 'btn btn-primary']) ?></p>
        </div>
    <?php endif; ?>
</div>