<?php
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;

/** @var yii\web\View $this */
/** @var app\models\Order $model */
/** @var app\models\Cart[] $cartItems */
/** @var float $totalPrice */
$this->title = 'Оформление заказа';
$this->params['breadcrumbs'][] = ['label' => 'Корзина', 'url' => ['cart/index']];
$this->params['breadcrumbs'][] = $this->title;
?>
    <div class="order-create">
        <h1><?= Html::encode($this->title) ?></h1>

        <div class="row">
            <div class="col-md-8">
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Содержимое заказа</h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($cartItems)): ?>
                            <div class="alert alert-warning">
                                Ваша корзина пуста.
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th>Товар</th>
                                        <th>Количество</th>
                                        <th>Цена</th>
                                        <th>Сумма</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach ($cartItems as $item): ?>
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <?= Html::img("@web/images/{$item->product->image}", [
                                                        'class' => 'img-thumbnail me-2',
                                                        'style' => 'width: 50px; height: 50px; object-fit: cover;',
                                                        'alt' => $item->product->name
                                                    ]) ?>
                                                    <span><?= Html::encode($item->product->name) ?></span>
                                                </div>
                                            </td>
                                            <td><?= $item->quantity ?> шт.</td>
                                            <td><?= $item->product->price ?> ₽</td>
                                            <td><?= $item->quantity * $item->product->price ?> ₽</td>
                                        </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="text-end fw-bold fs-5">
                                Итого: <?= $totalPrice ?> ₽
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">Детали заказа</h5>
                    </div>
                    <div class="card-body">
                        <?php $form = ActiveForm::begin(); ?>

                        <div class="card mb-3">
                            <div class="card-header">
                                <h6 class="mb-0">Способ оплаты</h6>
                            </div>
                            <div class="card-body">
                                <?= $form->field($model, 'payment_method')->radioList(
                                    $model::optsPaymentMethod(),
                                    [
                                        'class' => 'list-unstyled',
                                        'item' => function($index, $label, $name, $checked, $value) {
                                            $checked = $checked ? 'checked' : '';
                                            return "
                                            <div class='form-check mb-2'>
                                                <input class='form-check-input' type='radio' name='{$name}' value='{$value}' {$checked} id='payment-{$value}'>
                                                <label class='form-check-label' for='payment-{$value}'>
                                                    {$label}
                                                </label>
                                            </div>
                                        ";
                                        }
                                    ]
                                )->label(false) ?>
                            </div>
                        </div>

                        <div class="card mb-3">
                            <div class="card-header">
                                <h6 class="mb-0">Способ доставки</h6>
                            </div>
                            <div class="card-body">
                                <?= $form->field($model, 'delivery_method')->radioList(
                                    $model::optsDeliveryMethod(),
                                    [
                                        'class' => 'list-unstyled',
                                        'id' => 'order-delivery_method',
                                        'onchange' => 'toggleDeliveryFields()',
                                        'item' => function($index, $label, $name, $checked, $value) {
                                            $checked = $checked ? 'checked' : '';
                                            return "
                                            <div class='form-check mb-2'>
                                                <input class='form-check-input' type='radio' name='{$name}' value='{$value}' {$checked} id='delivery-{$value}' onchange='toggleDeliveryFields()'>
                                                <label class='form-check-label' for='delivery-{$value}'>
                                                    {$label}
                                                </label>
                                            </div>
                                        ";
                                        }
                                    ]
                                )->label(false) ?>
                            </div>
                        </div>

                        <div id="delivery-fields" style="display: none;">
                            <div class="card mb-3">
                                <div class="card-header">
                                    <h6 class="mb-0">Данные для доставки</h6>
                                </div>
                                <div class="card-body">
                                    <?= $form->field($model, 'delivery_address')->textarea([
                                        'rows' => 3,
                                        'placeholder' => 'Введите полный адрес доставки (улица, дом, квартира)',
                                        'class' => 'form-control'
                                    ])->label('Адрес доставки') ?>

                                    <?= $form->field($model, 'delivery_interval')->textInput([
                                        'placeholder' => 'Например: 10:00-18:00 или с 14 до 20 часов',
                                        'class' => 'form-control'
                                    ])->label('Удобное время доставки') ?>
                                </div>
                            </div>
                        </div>

                        <div class="card mb-3">
                            <div class="card-body text-center">
                                <div class="mb-3">
                                    <span class="fs-4 fw-bold">Итоговая сумма:</span>
                                    <span class="fs-4 fw-bold text-success ms-2" id="total-price">
                                    <?= $totalPrice ?> ₽
                                </span>
                                </div>
                                <div class="text-muted small" id="delivery-cost-info"></div>
                            </div>
                        </div>

                        <div class="mt-4">
                            <?php if (!empty($cartItems)): ?>
                                <?= Html::submitButton('Подтвердить и оплатить заказ', [
                                    'class' => 'btn btn-success btn-lg w-100'
                                ]) ?>
                            <?php else: ?>
                                <?= Html::a('Вернуться в корзину', ['cart/index'], [
                                    'class' => 'btn btn-primary w-100'
                                ]) ?>
                            <?php endif; ?>
                        </div>

                        <?php ActiveForm::end(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
$this->registerJs(<<<JS
function toggleDeliveryFields() {
    var deliveryMethod = $('input[name="Order[delivery_method]"]:checked').val();
    var deliveryFields = $('#delivery-fields');
    var totalPriceElement = $('#total-price');
    var deliveryCostInfo = $('#delivery-cost-info');
    var basePrice = {$totalPrice};
    
    if (deliveryMethod === 'courier') {
        deliveryFields.slideDown();
        // Делаем поля обязательными
        $('#order-delivery_address, #order-delivery_interval').prop('required', true);
        
        // Добавляем стоимость доставки
        var totalWithDelivery = basePrice + 300;
        totalPriceElement.text(totalWithDelivery + ' ₽');
        deliveryCostInfo.html('(включая доставку курьером: 300 ₽)');
    } else {
        deliveryFields.slideUp();
        // Убираем обязательность полей
        $('#order-delivery_address, #order-delivery_interval').prop('required', false);
        
        // Без стоимости доставки
        totalPriceElement.text(basePrice + ' ₽');
        deliveryCostInfo.html('(самовывоз, доставка не требуется)');
    }
}

// Инициализация при загрузке страницы
$(document).ready(function() {
    toggleDeliveryFields();
});
JS
);
?>