<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "products".
 *
 * @property int $id
 * @property string $name
 * @property string $image
 * @property string $description
 * @property int $counts
 * @property int $price
 * @property int $category_id
 *
 * @property Cart[] $carts
 * @property Category $category
 * @property OrderItem[] $orderItems
 */
class Product extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'products';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['counts'], 'default', 'value' => 1],
            [['name', 'image', 'description', 'price', 'category_id'], 'required'],
            [['description'], 'string'],
            [['counts', 'price', 'category_id'], 'integer'],
            [['name', 'image'], 'string', 'max' => 255],
            [['category_id'], 'exist', 'skipOnError' => true, 'targetClass' => Category::class, 'targetAttribute' => ['category_id' => 'id']],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'name' => 'Товар',
            'image' => 'Изображение',
            'description' => 'Описание',
            'counts' => 'Количество',
            'price' => 'Цена',
            'category_id' => 'Категория',
        ];
    }

    /**
     * Gets query for [[Carts]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCarts()
    {
        return $this->hasMany(Cart::class, ['product_id' => 'id']);
    }

    /**
     * Gets query for [[Category]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getCategory()
    {
        return $this->hasOne(Category::class, ['id' => 'category_id']);
    }

    /**
     * Gets query for [[OrderItem]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getOrderItems()
    {
        return $this->hasMany(OrderItem::class, ['product_id' => 'id']);
    }

    public function isAvailable()
    {
        return $this->counts > 0;
    }

    /**
     * Получает список доступных товаров
     * @return ActiveQuery
     */
    public static function getAvailableProducts()
    {
        return self::find()->where(['>', 'counts', 0]);
    }

    /**
     * Получает товар по ID с проверкой доступности
     * @param int $id
     * @return Product|null
     */
    public static function getAvailableProduct($id)
    {
        return self::find()
            ->where(['id' => $id])
            ->andWhere(['>', 'counts', 0])
            ->one();
    }
}
