<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;

class SiteController extends Controller
{
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
        ];
    }

    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
        ];
    }

    public function actionIndex()
    {
        // Популярные товары
        $popularProducts = \app\models\Product::find()
            ->where(['>', 'counts', 0])
            ->orderBy(['id' => SORT_DESC])
            ->limit(6)
            ->all();

        // Новинки
        $newProducts = \app\models\Product::find()
            ->where(['>', 'counts', 0])
            ->orderBy(['id' => SORT_DESC])
            ->limit(6)
            ->all();

        // Категории
        $categories = \app\models\Category::find()
            ->limit(6)
            ->all();

        return $this->render('index', [
            'popularProducts' => $popularProducts,
            'newProducts' => $newProducts,
            'categories' => $categories,
        ]);
    }

    public function actionAbout()
    {
        return $this->render('about');
    }

    public function actionContact()
    {
        $model = new \app\models\ContactForm();

        if ($model->load(Yii::$app->request->post()) && $model->contact(Yii::$app->params['adminEmail'])) {
            Yii::$app->session->setFlash('contactFormSubmitted');
            return $this->refresh();
        }

        return $this->render('contact', [
            'model' => $model,
        ]);
    }

    public function actionDelivery()
    {
        return $this->render('delivery');
    }

    public function actionPayment()
    {
        return $this->render('payment');
    }

    public function actionReturn()
    {
        return $this->render('return');
    }


    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->goHome();
        }

        $model = new \app\models\LoginForm();
        if ($model->load(Yii::$app->request->post()) && $model->login()) {
            return $this->goBack();
        }

        $model->password = '';
        return $this->render('login', [
            'model' => $model,
        ]);
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();
        return $this->goHome();
    }

    public function actionSignup()
    {
        $model = new \app\models\SignupForm();
        if ($model->load(Yii::$app->request->post())) {
            if ($user = $model->signup()) {
                if (Yii::$app->getUser()->login($user)) {
                    return $this->goHome();
                }
            }
        }

        return $this->render('signup', [
            'model' => $model,
        ]);
    }

}